cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

global type tavg
global distance 100


*Run at least once to produce smaller versions of the files to reduce load times for each type
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw.$type.dta", clear
keep if year >= 2000
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw small.$type.dta", replace

use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j.$type.dta", clear
keep if year >= 2000
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j small.$type.dta", replace


use crn_hcn_station_pairs_$distance.dta, clear

su station_pair_id
local max = r(max)

clear
tempfile results
cap gen date = 0
keep if _n < 0
sort date
save "`results'", replace

forvalues pair_id = 1(1)`max' {
	quietly {
	use crn_hcn_station_pairs_$distance.dta, clear
	keep if station_pair_id == `pair_id'
	local hcn_station_id = station_id_hcn[1]
	local crn_station_id = station_id_crn[1]
	local distance = distance[1]
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw small.$type.dta", clear
	destring station_id, replace
	keep if station_id == `hcn_station_id'
	rename avg hcn_raw_$type
	keep hcn_raw_$type date
	drop if hcn_raw_$type == . | hcn_raw_$type == -9999
	sort date
	tempfile hcn_raw_results
	save "`hcn_raw_results'", replace
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j small.$type.dta", clear
	destring station_id, replace
	keep if station_id == `hcn_station_id'
	rename avg hcn_adj_$type
	keep hcn_adj_$type date
	drop if hcn_adj_$type == . | hcn_adj_$type == -9999
	sort date
	tempfile hcn_adj_results
	save "`hcn_adj_results'", replace
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/crn_monthly_9_28_15.dta", clear
	keep if station_id == `crn_station_id'
	rename $type crn_$type
	gen date = ym(year, month)
	keep crn_$type date
	drop if crn_$type == . | crn_$type == -9999
	sort date
	merge date using "`hcn_raw_results'"
	keep if _merge == 3
	drop _merge
	sort date
	merge date using "`hcn_adj_results'"
	keep if _merge == 3
	drop _merge
	sort date	
	
	gen month = month(dofm(date))
	gen year = year(dofm(date))

	sort month	
	tempfile tempdata
	save "`tempdata'", replace

	collapse (mean) base_crn=crn_$type base_hcn_raw=hcn_raw_$type base_hcn_adj=hcn_adj_$type, by(month)
	sort month

	merge month using "`tempdata'"
	drop _merge
	replace crn_$type = crn_$type - base_crn
	replace hcn_raw_$type = hcn_raw_$type - base_hcn_raw
	replace hcn_adj_$type = hcn_adj_$type - base_hcn_adj
	drop base_crn base_hcn_raw base_hcn_adj
	
	gen adj_diff = hcn_adj_$type - crn_$type
	gen raw_diff = hcn_raw_$type - crn_$type
	
	keep adj_diff raw_diff date
	tsset date
	reg  raw_diff date
	estat durbinalt
	matrix b = r(p)
	local dw_raw = b[1,1]
	reg  adj_diff date
	estat durbinalt
	matrix b = r(p)
	local dw_adj = b[1,1]
	drop date
	keep if _n == _N
	gen dataset = "$type"
	gen hcn_id = `hcn_station_id'
	gen crn_id = `crn_station_id'
	gen pair_id = `pair_id'
	gen distance = `distance'
	gen dw_raw = `dw_raw'
	gen dw_adj = `dw_adj'

	append using "`results'"
	save "`results'", replace
	
	}
	display `pair_id'
}

use "`results'", clear
save "pair_dw_results $type $distance.dta", replace
